/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.block.entity;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.codecs.AgriSoil;
import com.agricraft.agricraft.api.config.CoreConfig;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.crop.AgriGrowthStage;
import com.agricraft.agricraft.api.fertilizer.AgriFertilizer;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.plant.AgriWeed;
import com.agricraft.agricraft.api.requirement.AgriGrowthConditionRegistry;
import com.agricraft.agricraft.api.requirement.AgriGrowthResponse;
import com.agricraft.agricraft.api.stat.AgriStat;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import com.agricraft.agricraft.api.tools.magnifying.MagnifyingInspectable;
import com.agricraft.agricraft.common.block.CropBlock;
import com.agricraft.agricraft.common.block.CropState;
import com.agricraft.agricraft.common.block.SimpleFluidloggedBlock;
import com.agricraft.agricraft.common.registry.ModBlockEntityTypes;
import com.agricraft.agricraft.common.util.LangUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CropBlockEntity
extends BlockEntity
implements AgriCrop,
MagnifyingInspectable {
    private final Map<Integer, VoxelShape> shapeByAge = new HashMap<Integer, VoxelShape>();
    private AgriGenome genome;
    private String plantId = "";
    private AgriPlant plant;
    private AgriGrowthStage growthStage = null;
    private String weedId = "";
    private AgriWeed weed;
    private AgriGrowthStage weedGrowthStage = null;

    public CropBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.CROP.get(), blockPos, blockState);
    }

    public void m_142466_(CompoundTag tag) {
        boolean hasWeeds;
        super.m_142466_(tag);
        boolean hasPlant = tag.m_128471_("hasPlant");
        if (hasPlant) {
            this.genome = AgriGenome.fromNBT(tag);
            this.plantId = this.genome == null ? "agricraft:unknown" : this.genome.getSpeciesGene().getDominant().trait();
            int growthIndex = tag.m_128451_("growthIndex");
            int growthTotal = tag.m_128451_("growthTotal");
            this.growthStage = new AgriGrowthStage(growthIndex, growthTotal);
            if (this.plant == null && this.f_58857_ != null) {
                this.plant = AgriApi.getPlant(this.plantId, this.f_58857_.m_9598_()).orElse(null);
            }
        }
        if (hasWeeds = tag.m_128471_("hasWeeds")) {
            this.weedId = tag.m_128461_("weedId");
            int weedGrowthIndex = tag.m_128451_("weedGrowthIndex");
            int weedGrowthTotal = tag.m_128451_("weedGrowthTotal");
            this.weedGrowthStage = new AgriGrowthStage(weedGrowthIndex, weedGrowthTotal);
            if (this.weed == null && this.f_58857_ != null) {
                this.weed = AgriApi.getWeed(this.weedId, this.f_58857_.m_9598_()).orElse(null);
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.hasPlant()) {
            tag.m_128379_("hasPlant", true);
            this.genome.writeToNBT(tag);
            tag.m_128405_("growthIndex", this.growthStage.index());
            tag.m_128405_("growthTotal", this.growthStage.total());
        } else {
            tag.m_128379_("hasPlant", false);
        }
        if (this.hasWeeds()) {
            tag.m_128379_("hasWeeds", true);
            tag.m_128359_("weedId", this.weedId);
            tag.m_128405_("weedGrowthIndex", this.weedGrowthStage.index());
            tag.m_128405_("weedGrowthTotal", this.weedGrowthStage.total());
        } else {
            tag.m_128379_("hasWeeds", false);
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        if (level != null && !level.f_46443_) {
            this.plant = AgriApi.getPlant(this.plantId, level.m_9598_()).orElse(null);
            if (this.plant != null && this.growthStage == null) {
                this.growthStage = this.plant.getInitialGrowthStage();
            }
            this.weed = AgriApi.getWeed(this.weedId, level.m_9598_()).orElse(null);
            if (this.weed != null && this.growthStage == null) {
                this.growthStage = this.weed.getInitialGrowthStage();
            }
            level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    public boolean removeGenome() {
        if (this.hasPlant()) {
            if (this.m_58900_().m_61143_(CropBlock.CROP_STATE) == CropState.PLANT_STICKS) {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(CropBlock.CROP_STATE, (Comparable)((Object)CropState.SINGLE_STICKS)));
            } else if (((Boolean)this.m_58900_().m_61143_((Property)SimpleFluidloggedBlock.LAVALOGGED)).booleanValue()) {
                this.f_58857_.m_46597_(this.m_58899_(), Fluids.f_76195_.m_76145_().m_76188_());
            } else if (((Boolean)this.m_58900_().m_61143_((Property)SimpleFluidloggedBlock.WATERLOGGED)).booleanValue()) {
                this.f_58857_.m_46597_(this.m_58899_(), Fluids.f_76193_.m_76145_().m_76188_());
            } else {
                this.f_58857_.m_46597_(this.m_58899_(), Blocks.f_50016_.m_49966_());
            }
            this.getPlant().onRemoved(this);
            this.genome = null;
            this.plant = null;
            this.plantId = "";
            this.growthStage = null;
            return true;
        }
        return false;
    }

    @Override
    public AgriGenome getGenome() {
        return this.genome;
    }

    @Override
    public void plantGenome(AgriGenome genome, @Nullable LivingEntity entity) {
        if (genome == null) {
            return;
        }
        this.genome = genome;
        this.plantId = genome.getSpeciesGene().getDominant().trait();
        this.plant = AgriApi.getPlant(this.plantId, this.f_58857_.m_9598_()).orElse(null);
        if (this.plant != null) {
            this.growthStage = this.plant.getInitialGrowthStage();
        }
        this.f_58857_.m_7731_(this.m_58899_(), this.hasCropSticks() ? (BlockState)((BlockState)this.m_58900_().m_61124_(CropBlock.CROP_STATE, (Comparable)((Object)CropState.PLANT_STICKS))).m_61124_((Property)CropBlock.LIGHT, (Comparable)Integer.valueOf(this.plant.getBrightness(this))) : (BlockState)this.m_58900_().m_61124_((Property)CropBlock.LIGHT, (Comparable)Integer.valueOf(this.plant.getBrightness(this))), 3);
        this.plant.onPlanted(this, null);
    }

    @Override
    public boolean hasPlant() {
        return ((CropState)((Object)this.m_58900_().m_61143_(CropBlock.CROP_STATE))).hasPlant() && !this.plantId.isEmpty() && this.plant != null;
    }

    @Override
    public boolean hasWeeds() {
        return !this.weedId.isEmpty() && this.weed != null;
    }

    @Override
    public boolean hasCropSticks() {
        return ((CropState)((Object)this.m_58900_().m_61143_(CropBlock.CROP_STATE))).hasSticks();
    }

    @Override
    public boolean isCrossCropSticks() {
        return this.m_58900_().m_61143_(CropBlock.CROP_STATE) == CropState.DOUBLE_STICKS;
    }

    @Override
    public String getPlantId() {
        return this.plantId;
    }

    @Override
    public AgriPlant getPlant() {
        return this.plant;
    }

    @Override
    public AgriGrowthStage getGrowthStage() {
        return this.growthStage;
    }

    @Override
    public String getWeedId() {
        return this.weedId;
    }

    @Override
    public AgriWeed getWeed() {
        return this.weed;
    }

    @Override
    public AgriGrowthStage getWeedGrowthStage() {
        return this.weedGrowthStage;
    }

    @Override
    public void setGrowthStage(AgriGrowthStage stage) {
        this.growthStage = stage;
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)CropBlock.LIGHT, (Comparable)Integer.valueOf(this.plant.getBrightness(this))), 3);
    }

    @Override
    public void setWeedGrowthStage(AgriGrowthStage stage) {
        this.weedGrowthStage = stage;
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.hasPlant() ? (BlockState)this.m_58900_().m_61124_((Property)CropBlock.LIGHT, (Comparable)Integer.valueOf(this.plant.getBrightness(this))) : this.m_58900_(), 3);
    }

    @Override
    public void removeWeeds() {
        if (this.hasWeeds()) {
            this.weed = null;
            this.weedId = "";
            this.weedGrowthStage = null;
            this.m_6596_();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.hasPlant() ? (BlockState)this.m_58900_().m_61124_((Property)CropBlock.LIGHT, (Comparable)Integer.valueOf(this.plant.getBrightness(this))) : this.m_58900_(), 3);
        }
    }

    @Override
    public AgriGrowthResponse getFertilityResponse() {
        if (!this.checkGrowthSpace(this.plant.getPlantHeight(this.growthStage))) {
            return AgriGrowthResponse.INFERTILE;
        }
        if (AgriGrowthConditionRegistry.getInstance().isEmpty()) {
            return AgriGrowthResponse.FERTILE;
        }
        int strength = this.genome.getStatGene(AgriStatRegistry.getInstance().strengthStat()).getTrait();
        Optional<AgriGrowthResponse> optional = AgriGrowthConditionRegistry.getInstance().stream().map(condition -> condition.check(this, this.f_58857_, this.m_58899_(), strength)).reduce((result, element) -> result.priority() >= element.priority() ? result : element);
        return optional.orElse(AgriGrowthResponse.FERTILE);
    }

    @Override
    public Optional<AgriSoil> getSoil() {
        return AgriApi.getSoil((BlockGetter)this.f_58857_, this.m_58899_().m_7495_(), this.f_58857_.m_9598_());
    }

    public VoxelShape getShape() {
        double yoffset = 0.0;
        if (this.f_58857_.m_8055_(this.m_58899_().m_7495_()).m_60713_(Blocks.f_50093_)) {
            yoffset = -0.0625;
        }
        if (!this.hasPlant()) {
            if (this.hasWeeds()) {
                return this.shapeByAge.computeIfAbsent(this.weedGrowthStage.index(), stage -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)this.weed.getWeedHeight(this.weedGrowthStage), (double)16.0)).m_83216_(0.0, yoffset, 0.0);
            }
            return Shapes.m_83040_();
        }
        return this.shapeByAge.computeIfAbsent(this.growthStage.index(), stage -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)this.plant.getPlantHeight(this.growthStage), (double)16.0)).m_83216_(0.0, yoffset, 0.0);
    }

    @Override
    public void getHarvestProducts(Consumer<ItemStack> addToHarvest) {
        if (!this.hasPlant() || !this.isFullyGrown()) {
            return;
        }
        for (int trials = (this.genome.getGain() + 3) / 3; trials > 0; --trials) {
            this.plant.getHarvestProducts(addToHarvest, this.growthStage, this.genome, this.f_58857_.f_46441_);
        }
    }

    @Override
    public void getClippingProducts(Consumer<ItemStack> addToClipping, ItemStack clipper) {
        if (!this.hasPlant() || !this.isFullyGrown()) {
            return;
        }
        this.plant.getClipProducts(addToClipping, clipper, this.growthStage, this.genome, this.f_58857_.f_46441_);
    }

    @Override
    public boolean acceptsFertilizer(AgriFertilizer fertilizer) {
        if (this.isCrossCropSticks()) {
            return CoreConfig.allowFertilizerMutation && fertilizer.canTriggerMutation();
        }
        if (this.hasPlant()) {
            return !this.isFullyGrown() && fertilizer.canFertilize(this);
        }
        return fertilizer.canTriggerWeeds();
    }

    @Override
    public void applyGrowthTick() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        if (this.shouldWeedsActivate()) {
            this.executeWeedsGrowthTick();
        } else if (this.m_58900_().m_61143_(CropBlock.CROP_STATE) == CropState.DOUBLE_STICKS) {
            AgriApi.getMutationHandler().getActiveCrossBreedEngine().handleCrossBreedTick(this, this.streamNeighbours(), this.f_58857_.f_46441_);
        } else {
            if (!this.hasPlant()) {
                return;
            }
            AgriGrowthResponse fertility = this.getFertilityResponse();
            if (fertility.isInstantKill()) {
                fertility.onPlantKilled(this);
                this.removeGenome();
            } else if (fertility.isLethal()) {
                this.revertGrowthStage();
            } else if (fertility.isFertile()) {
                this.executePlantGrowthTick();
            }
        }
    }

    protected void executeWeedsGrowthTick() {
        if (!this.hasWeeds()) {
            AgriApi.getWeedRegistry().flatMap(registry -> registry.m_6579_().stream().filter(entry -> this.f_58857_.m_213780_().m_188500_() < ((AgriWeed)entry.getValue()).getSpawnChance(this)).findAny()).ifPresent(entry -> this.setWeed(((ResourceKey)entry.getKey()).m_135782_().toString(), (AgriWeed)entry.getValue()));
        } else if (this.weedGrowthStage.isFinal()) {
            this.tryWeedKillPlant();
            this.spreadWeeds();
        } else {
            double f = this.getSoil().map(AgriSoil::growthModifier).orElse(1.0);
            if (this.f_58857_.m_213780_().m_188500_() < f * this.weed.getGrowthChance(this.weedGrowthStage)) {
                this.weedGrowthStage = this.weedGrowthStage.getNext(this, this.f_58857_.m_213780_());
                this.m_6596_();
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.hasPlant() ? (BlockState)this.m_58900_().m_61124_((Property)CropBlock.LIGHT, (Comparable)Integer.valueOf(this.plant.getBrightness(this))) : this.m_58900_(), 3);
            }
        }
    }

    @Override
    public void setWeed(String weedId, AgriWeed weed) {
        if (this.checkGrowthSpace(weed.getWeedHeight(weed.getInitialGrowthStage()))) {
            this.weedId = weedId;
            this.weed = weed;
            this.weedGrowthStage = weed.getInitialGrowthStage();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.hasPlant() ? (BlockState)this.m_58900_().m_61124_((Property)CropBlock.LIGHT, (Comparable)Integer.valueOf(this.plant.getBrightness(this))) : this.m_58900_(), 3);
        }
    }

    protected void tryWeedKillPlant() {
        if (CoreConfig.matureWeedsKillPlants && this.weed.isLethal() && this.hasPlant() && this.shouldWeedsActivate()) {
            this.revertGrowthStage();
        }
    }

    protected void spreadWeeds() {
        if (CoreConfig.weedsSpreading && this.weed.isAggressive()) {
            this.streamNeighbours().filter(crop -> !crop.hasWeeds()).filter(AgriCrop::shouldWeedsActivate).forEach(crop -> crop.setWeed(this.weedId, this.weed));
        }
    }

    public boolean checkGrowthSpace(int height) {
        if (this.f_58857_ == null) {
            return false;
        }
        while (height > 16) {
            int offset = height / 16;
            BlockPos up = this.m_58899_().m_6630_(offset);
            if (!this.f_58857_.m_8055_(up).m_60795_()) {
                return false;
            }
            height -= 16;
        }
        return true;
    }

    public Stream<AgriCrop> streamNeighbours() {
        return Direction.Plane.HORIZONTAL.m_122557_().map(dir -> this.m_58899_().m_121945_(dir)).map(pos -> AgriApi.getCrop((BlockGetter)this.f_58857_, pos)).filter(Optional::isPresent).map(Optional::get);
    }

    protected void revertGrowthStage() {
        AgriGrowthStage current = this.growthStage;
        AgriGrowthStage prev = this.growthStage.getPrevious(this, this.f_58857_.f_46441_);
        if (current.equals(prev)) {
            this.removeGenome();
        } else {
            this.setGrowthStage(prev);
        }
    }

    protected void executePlantGrowthTick() {
        double b;
        if (this.isFullyGrown()) {
            return;
        }
        double a = this.calculateGrowthRate();
        if (a > (b = this.f_58857_.f_46441_.m_188500_())) {
            this.setGrowthStage(this.growthStage.getNext(this, this.f_58857_.f_46441_));
            this.getPlant().onGrowth(this);
        }
    }

    protected double calculateGrowthRate() {
        int growth = this.genome.getStatGene(AgriStatRegistry.getInstance().growthStat()).getTrait();
        double soilFactor = this.getSoil().map(AgriSoil::growthModifier).orElse(1.0);
        return soilFactor * (this.plant.getGrowthChance(this.growthStage) + (double)growth * this.plant.getBonusGrowthChance(this.growthStage) * CoreConfig.growthMultiplier);
    }

    @Override
    public void addMagnifyingTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.hasPlant()) {
            tooltip.add((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.crop"));
            tooltip.add((Component)Component.m_237113_((String)"  ").m_6879_().m_7220_((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.species")).m_7220_(LangUtils.plantName(this.genome.getSpeciesGene().getDominant().trait())).m_7220_((Component)Component.m_237113_((String)" - ").m_6879_()).m_7220_(LangUtils.plantName(this.genome.getSpeciesGene().getRecessive().trait())));
            AgriStatRegistry.getInstance().stream().filter(stat -> !stat.isHidden()).map(stat -> this.genome.getStatGene((AgriStat)stat)).sorted(Comparator.comparing(p -> p.getGene().getId())).map(genePair -> Component.m_237110_((String)("agricraft.tooltip.magnifying.stat." + genePair.getGene().getId()), (Object[])new Object[]{genePair.getDominant().trait(), genePair.getRecessive().trait()})).map(component -> Component.m_237113_((String)"  ").m_7220_((Component)component)).forEach(tooltip::add);
            if (isPlayerSneaking) {
                tooltip.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237110_((String)"agricraft.tooltip.magnifying.growth", (Object[])new Object[]{this.growthStage.index() + 1, this.growthStage.total()})));
            }
            if (this.f_58857_.f_46443_) {
                this.f_58857_.m_46465_();
            }
            AgriGrowthResponse response = this.getFertilityResponse();
            tooltip.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)("agricraft.tooltip.magnifying.requirement." + (response.isLethal() ? "lethal" : (response.isFertile() ? "fertile" : "not_fertile"))))));
            if (!response.isFertile()) {
                if (!this.checkGrowthSpace(this.plant.getPlantHeight(this.growthStage))) {
                    tooltip.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"agricraft.tooltip.condition.growth_space")));
                }
                int strength = this.genome.getStrength();
                AgriGrowthConditionRegistry.getInstance().stream().filter(condition -> !condition.check(this, this.f_58857_, this.m_58899_(), strength).isFertile()).forEach(condition -> condition.notMetDescription(component -> tooltip.add((Component)Component.m_237113_((String)"  ").m_7220_(component))));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.no_plant"));
        }
        if (this.hasWeeds()) {
            tooltip.add((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.weeds").m_7220_(LangUtils.weedName(this.weedId)));
            if (isPlayerSneaking) {
                tooltip.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237110_((String)"agricraft.tooltip.magnifying.growth", (Object[])new Object[]{this.weedGrowthStage.index() + 1, this.weedGrowthStage.total()})));
            }
        }
    }

    @Override
    public BlockPos m_58899_() {
        return super.m_58899_();
    }

    @Override
    public BlockState m_58900_() {
        return super.m_58900_();
    }

    @Override
    @Nullable
    public Level m_58904_() {
        return super.m_58904_();
    }
}

